/*
 * Project: N|Watch
 * Author: Zak Kemble, contact@zakkemble.co.uk
 * Copyright: (C) 2014 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 * Web: http://blog.zakkemble.co.uk/diy-digital-wristwatch/
 */

#ifndef RUSSIAN_H_
#define RUSSIAN_H_

// Thanks to Onatsky Sergei (Le_Fleurs (-at-) mail (-dot-) ru) for translating!

// Encoding: Windows-1251
// Editing this file with AtmelStudio might mess it up, use something like Notepad++ and set the Encoding to Windows-1251 (Tool bar at the top -> Encoding -> Character sets -> Cyrillic -> Windows-1251).


// String buffer sizes
// Don't forget to add 1 for null terminator
#define BUFFSIZE_STR_MENU	24
#define BUFFSIZE_STR_DAYS	4
#define BUFFSIZE_STR_MONTHS	4

#define BUFFSIZE_DATE_FORMAT		((BUFFSIZE_STR_DAYS - 1) + (BUFFSIZE_STR_MONTHS - 1) + 12)
#define BUFFSIZE_TIME_FORMAT_SMALL		9



// String formats
#define DATE_FORMAT ("%s %02hhu %s 20%02hhu")
#define TIME_FORMAT_SMALL ("%02hhu:%02hhu%c")




#define CHAR_DEGREES	127
#define CHAR_TICK		128

#define CHAR_AM	'A'
#define CHAR_PM	'P'
#define CHAR_24	' '

#define CHAR_YES	'Y'
#define CHAR_NO		'N'

#define STR_DOWCHARS	""



// Days
// Also see BUFFSIZE_STR_DAYS
#define STR_MON			""
#define STR_TUE			""
#define STR_WED			""
#define STR_THU			""
#define STR_FRI			""
#define STR_SAT			""
#define STR_SUN			""

// Months
// Also see BUFFSIZE_STR_MONTHS
#define STR_JAN			""
#define STR_FEB			""
#define STR_MAR			""
#define STR_APR			""
#define STR_MAY			""
#define STR_JUN			""
#define STR_JUL			""
#define STR_AUG			""
#define STR_SEP			""
#define STR_OCT			""
#define STR_NOV			""
#define STR_DEC			""


// Menu strings
// Also see BUFFSIZE_STR_MENU

#define STR_MAINMENU	"<   >"
#define STR_ALARMS		""
#define STR_FLASHLIGHT	""
#define STR_STOPWATCH	""
#define STR_GAMES		""
#define STR_SETTINGS	""
#define STR_DIAGNOSTICS	""
//#define STR_BTRCCAR		"BT RC Car"
//#define STR_TUNEMAKER	"Tune maker"
//#define STR_CALCULATORS	"Calculators"

#define STR_ALARMSMENU	"<  >"

#define STR_TIMEDATEMENU	"<    >"
#define STR_SAVE		""
#define STR_SAVED		""

#define STR_DIAGNOSTICSMENU	"<  >"
#define STR_TEMPERATURE		" %hhd.%hhuC"
#define STR_BATTERY			" %umV"
#define STR_SHOWFPS			" FPS%9c"

#define STR_DISPLAYMENU	"<  >"
#define STR_BRIGHTNESS	""
#define STR_INVERT		""
#define STR_ROTATE		""
#define STR_ANIMATIONS	""

#define STR_GAMESMENU	"<  >"

#define STR_SOUNDMENU	"<  >"
#define STR_UI			"UI"
#define STR_HOURBEEPS	" "

#define STR_SLEEPMENU	"<  >"
#define STR_TIMEOUT		"-"
//#define STR_CLOCKMODE	"Clock mode"

#define STR_SETTINGSMENU	"<  >"
#define STR_TIMEDATE	"  "
#define STR_SLEEP		""
#define STR_SOUND		""
#define STR_DISPLAY		""
#define STR_LEDS		""
//#define STR_RCSETTINGS	"RC Settings"

#define STR_BACK		""
#define STR_EXIT		""




// Game strings

#define STR_GAME1		"Breakout"
#define STR_GAME2		"Car Dodge"

#define STR_WIN			"!"
#define STR_GAMEOVER	" !"
#define STR_SCORE		":"
#define STR_HIGHSCORE	":"
#define STR_NEWHIGHSCORE	"! !"



// Little images (8x8) for showing day of week of next alarm on main screen

#define DOWIMG_MON 0x1F,0x01,0x1F,0x00,0xF8,0x20,0xF8,0x00 
#define DOWIMG_TUE 0x1F,0x15,0x1B,0x00,0x08,0xF8,0x08,0x00
#define DOWIMG_WED 0x1F,0x11,0x11,0x00,0xF8,0x28,0x38,0x00
#define DOWIMG_THU 0x07,0x04,0x1F,0x00,0x08,0xF8,0x08,0x00
#define DOWIMG_FRI 0x1F,0x01,0x1F,0x00,0x08,0xF8,0x08,0x00
#define DOWIMG_SAT 0x1F,0x11,0x11,0x00,0xF8,0xA8,0xE8,0x00
#define DOWIMG_SUN 0x1F,0x15,0x1B,0x00,0xF8,0x88,0x88,0x00


// Character set for this language

#define CHARACTER_SET \
{0x00,0x00,0x00,0x00,0x00},/* space */ \
{0x00,0x5F,0x00,0x00,0x00},/* ! */ \
{0x00,0x07,0x00,0x07,0x00},/* " */ \
{0x14,0x7F,0x14,0x7F,0x14},/* # */ \
{0x24,0x2A,0x7F,0x2A,0x12},/* $ */ \
{0x23,0x13,0x08,0x64,0x62},/* % */ \
{0x36,0x49,0x55,0x22,0x50},/* & */ \
{0x00,0x05,0x03,0x00,0x00},/* ' */ \
{0x1C,0x22,0x41,0x00,0x00},/* ( */ \
{0x41,0x22,0x1C,0x00,0x00},/* ) */ \
{0x08,0x2A,0x1C,0x2A,0x08},/* * */ \
{0x08,0x08,0x3E,0x08,0x08},/* + */ \
{0xA0,0x60,0x00,0x00,0x00},/* , */ \
{0x08,0x08,0x08,0x08,0x08},/* - */ \
{0x60,0x60,0x00,0x00,0x00},/* . */ \
{0x20,0x10,0x08,0x04,0x02},/* / */ \
{0x3E,0x51,0x49,0x45,0x3E},/* 0 */ \
{0x00,0x42,0x7F,0x40,0x00},/* 1 */ \
{0x62,0x51,0x49,0x49,0x46},/* 2 */ \
{0x22,0x41,0x49,0x49,0x36},/* 3 */ \
{0x18,0x14,0x12,0x7F,0x10},/* 4 */ \
{0x27,0x45,0x45,0x45,0x39},/* 5 */ \
{0x3C,0x4A,0x49,0x49,0x30},/* 6 */ \
{0x01,0x71,0x09,0x05,0x03},/* 7 */ \
{0x36,0x49,0x49,0x49,0x36},/* 8 */ \
{0x06,0x49,0x49,0x29,0x1E},/* 9 */ \
{0x00,0x36,0x36,0x00,0x00},/* : */ \
{0x00,0xAC,0x6C,0x00,0x00},/*  ; */ \
{0x08,0x14,0x22,0x41,0x00},/* < */ \
{0x14,0x14,0x14,0x14,0x14},/* = */ \
{0x41,0x22,0x14,0x08,0x00},/* > */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x32,0x49,0x79,0x41,0x3E},/* @ */ \
{0x7E,0x09,0x09,0x09,0x7E},/* A */ \
{0x7F,0x49,0x49,0x49,0x36},/* B */ \
{0x3E,0x41,0x41,0x41,0x22},/* C */ \
{0x7F,0x41,0x41,0x22,0x1C},/* D */ \
{0x7F,0x49,0x49,0x49,0x41},/* E */ \
{0x7F,0x09,0x09,0x09,0x01},/* F */ \
{0x3E,0x41,0x41,0x51,0x72},/* G */ \
{0x7F,0x08,0x08,0x08,0x7F},/* H */ \
{0x41,0x7F,0x41,0x00,0x00},/* I */ \
{0x20,0x40,0x41,0x3F,0x01},/* J */ \
{0x7F,0x08,0x14,0x22,0x41},/* K */ \
{0x7F,0x40,0x40,0x40,0x40},/* L */ \
{0x7F,0x02,0x0C,0x02,0x7F},/* M */ \
{0x7F,0x04,0x08,0x10,0x7F},/* N */ \
{0x3E,0x41,0x41,0x41,0x3E},/* O */ \
{0x7F,0x09,0x09,0x09,0x06},/* P */ \
{0x3E,0x41,0x51,0x21,0x5E},/* Q */ \
{0x7F,0x09,0x19,0x29,0x46},/* R */ \
{0x26,0x49,0x49,0x49,0x32},/* S */ \
{0x01,0x01,0x7F,0x01,0x01},/* T */ \
{0x3F,0x40,0x40,0x40,0x3F},/* U */ \
{0x1F,0x20,0x40,0x20,0x1F},/* V */ \
{0x3F,0x40,0x38,0x40,0x3F},/* W */ \
{0x63,0x14,0x08,0x14,0x63},/* X */ \
{0x03,0x04,0x78,0x04,0x03},/* Y */ \
{0x61,0x51,0x49,0x45,0x43},/* Z */ \
{0x7F,0x41,0x41,0x00,0x00},/* [ */ \
{0x02,0x04,0x08,0x10,0x20},/* \ */ \
{0x41,0x41,0x7F,0x00,0x00},/* ] */ \
{0x04,0x02,0x01,0x02,0x04},/* ^ */ \
{0x80,0x80,0x80,0x80,0x80},/* _ */ \
{0x01,0x02,0x04,0x00,0x00},/* ' */ \
{0x20,0x54,0x54,0x54,0x78},/* a */ \
{0x7F,0x48,0x44,0x44,0x38},/* b */ \
{0x38,0x44,0x44,0x28,0x00},/* c */ \
{0x38,0x44,0x44,0x48,0x7F},/* d */ \
{0x38,0x54,0x54,0x54,0x18},/* e */ \
{0x08,0x7E,0x09,0x02,0x00},/* f */ \
{0x18,0xA4,0xA4,0xA4,0x7C},/* g */ \
{0x7F,0x08,0x04,0x04,0x78},/* h */ \
{0x00,0x7D,0x00,0x00,0x00},/* i */ \
{0x80,0x84,0x7D,0x00,0x00},/* j */ \
{0x7F,0x10,0x28,0x44,0x00},/* k */ \
{0x41,0x7F,0x40,0x00,0x00},/* l */ \
{0x7C,0x04,0x18,0x04,0x78},/* m */ \
{0x7C,0x08,0x04,0x7C,0x00},/* n */ \
{0x38,0x44,0x44,0x38,0x00},/* o */ \
{0xFC,0x24,0x24,0x18,0x00},/* p */ \
{0x18,0x24,0x24,0xFC,0x00},/* q */ \
{0x00,0x7C,0x08,0x04,0x00},/* r */ \
{0x48,0x54,0x54,0x24,0x00},/* s */ \
{0x04,0x7F,0x44,0x00,0x00},/* t */ \
{0x3C,0x40,0x40,0x7C,0x00},/* u */ \
{0x1C,0x20,0x40,0x20,0x1C},/* v */ \
{0x3C,0x40,0x30,0x40,0x3C},/* w */ \
{0x44,0x28,0x10,0x28,0x44},/* x */ \
{0x1C,0xA0,0xA0,0x7C,0x00},/* y */ \
{0x44,0x64,0x54,0x4C,0x44},/* z */ \
{0x08,0x36,0x41,0x00,0x00},/* { */ \
{0x00,0x7F,0x00,0x00,0x00},/* | */ \
{0x41,0x36,0x08,0x00,0x00},/* } */ \
{0x02,0x01,0x01,0x02,0x01},/* ~ */ \
{0x02,0x05,0x05,0x02,0x00},/* degrees (non-standard, normally DEL) */ \
{0x60,0xC0,0xF0,0x38,0x1C},/* tick (non-standard) */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
{0x02,0x01,0x51,0x09,0x06},/* ? */ \
/* RUS SYSTEM BIG */ \
{0x7e,0x11,0x11,0x11,0x7e},/*A */ \
{0x7f,0x49,0x49,0x49,0x33},/* */ \
{0x7f,0x49,0x49,0x49,0x36},/* */ \
{0x7f,0x01,0x01,0x01,0x03},/* */ \
{0xe0,0x51,0x4f,0x41,0xff},/* */ \
{0x7f,0x49,0x49,0x49,0x41},/*E */ \
{0x77,0x08,0x7f,0x08,0x77},/* */ \
{0x41,0x49,0x49,0x49,0x36},/* */ \
{0x7f,0x10,0x08,0x04,0x7f},/* */ \
{0x7c,0x21,0x12,0x09,0x7c},/* */ \
{0x7f,0x08,0x14,0x22,0x41},/*K */ \
{0x20,0x41,0x3f,0x01,0x7f},/* */ \
{0x7f,0x02,0x0c,0x02,0x7f},/*M */ \
{0x7f,0x08,0x08,0x08,0x7f},/*H */ \
{0x3e,0x41,0x41,0x41,0x3e},/*O */ \
{0x7f,0x01,0x01,0x01,0x7f},/* */ \
{0x7f,0x09,0x09,0x09,0x06},/*P */ \
{0x3e,0x41,0x41,0x41,0x22},/*C */ \
{0x01,0x01,0x7f,0x01,0x01},/*T */ \
{0x47,0x28,0x10,0x08,0x07},/* */ \
{0x1c,0x22,0x7f,0x22,0x1c},/* */ \
{0x63,0x14,0x08,0x14,0x63},/*X */ \
{0x7f,0x40,0x40,0x40,0xff},/* */ \
{0x07,0x08,0x08,0x08,0x7f},/* */ \
{0x7f,0x40,0x7f,0x40,0x7f},/* */ \
{0x7f,0x40,0x7f,0x40,0xff},/* */ \
{0x01,0x7f,0x48,0x48,0x30},/* */ \
{0x7f,0x48,0x30,0x00,0x7f},/* */ \
{0x00,0x7f,0x48,0x48,0x30},/* */ \
{0x22,0x41,0x49,0x49,0x3e},/* */ \
{0x7f,0x08,0x3e,0x41,0x3e},/* */ \
{0x46,0x29,0x19,0x09,0x7f},/* */ \
/* RUS SYSTEM Litle */ \
{0x20,0x54,0x54,0x54,0x78},/*a */ \
{0x3c,0x4a,0x4a,0x49,0x31},/* */ \
{0x7c,0x54,0x54,0x28,0x00},/* */ \
{0x7c,0x04,0x04,0x04,0x0c},/* */ \
{0xe0,0x54,0x4c,0x44,0xfc},/* */ \
{0x38,0x54,0x54,0x54,0x18},/*e */ \
{0x6c,0x10,0x7c,0x10,0x6c},/* */ \
{0x44,0x44,0x54,0x54,0x28},/* */ \
{0x7c,0x20,0x10,0x08,0x7c},/* */ \
{0x7c,0x41,0x22,0x11,0x7c},/* */ \
{0x7c,0x10,0x28,0x44,0x00},/* */ \
{0x20,0x44,0x3c,0x04,0x7c},/* */ \
{0x7c,0x08,0x10,0x08,0x7c},/* */ \
{0x7c,0x10,0x10,0x10,0x7c},/* */ \
{0x38,0x44,0x44,0x44,0x38},/*o */ \
{0x7c,0x04,0x04,0x04,0x7c},/* */ \
{0x7C,0x14,0x14,0x14,0x08},/*p */ \
{0x38,0x44,0x44,0x44,0x20},/*c */ \
{0x04,0x04,0x7c,0x04,0x04},/* */ \
{0x0C,0x50,0x50,0x50,0x3C},/* */ \
{0x30,0x48,0xfc,0x48,0x30},/* */ \
{0x44,0x28,0x10,0x28,0x44},/*x */ \
{0x7c,0x40,0x40,0x40,0xfc},/* */ \
{0x0c,0x10,0x10,0x10,0x7c},/* */ \
{0x7c,0x40,0x7c,0x40,0x7c},/* */ \
{0x7c,0x40,0x7c,0x40,0xfc},/* */ \
{0x04,0x7c,0x50,0x50,0x20},/* */ \
{0x7c,0x50,0x50,0x20,0x7c},/* */ \
{0x7c,0x50,0x50,0x20,0x00},/* */ \
{0x28,0x44,0x54,0x54,0x38},/* */ \
{0x7c,0x10,0x38,0x44,0x38},/* */ \
{0x08,0x54,0x34,0x14,0x7c},/* */

#endif /* RUSSIAN_H_ */
