/*
  avr8_ac.cpp - AC Driver for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#include "avr8_ac.h"

Ac* Ac::_instances[];

#if CONFIG_AC_ISR

inline void ac_isr_cmp(uint8_t ch)
{
  Ac::_instances[ch]->isr_cmp();
}

#if defined(AC0_AC_vect)
ISR(AC0_AC_vect)
{
  ac_isr_cmp(0);
}
#endif

#if defined(AC1_AC_vect)
ISR(AC1_AC_vect)
{
  ac_isr_cmp(1);
}
#endif

#if defined(AC2_AC_vect)
ISR(AC2_AC_vect)
{
  ac_isr_cmp(2);
}
#endif

#endif

