/*
  avr8_alarm.h - Alarm Library for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#pragma once

#include "avr8_config.h"

#if CONFIG_TASK_USE || CONFIG_ALARM_USE

#include <stddef.h>
#include <stdint.h>
#include <stdbool.h>
#include "avr8_timer.h"

class Alarm : public TimerClass
{
  public:

    typedef bool (*handler_t)(Alarm& alarm);

    Alarm& interval(int32_t interval, bool fromnow = true);
    int32_t interval(void);
    Alarm& handler(handler_t handler);
    handler_t handler(void);
    Alarm& param(uint8_t num, void *val);
    void *param(uint8_t num);
    bool expire(void);

  protected:

    friend class AlarmClass;

    Alarm    *_next;
    uint32_t  _alarm;
    int32_t   _interval;
    handler_t _handler;
    void     *_params[4];
};

class AlarmClass : protected TimerClass
{
  public:

    AlarmClass(void);
    void begin(void);
    bool start(Alarm& alarm);
    void cancel(Alarm& alarm);
    void cancel(uint8_t num, void *arg);
    void handle(void);

  protected:

    bool add(Alarm& alarm);

  private:

    bool timeup(void);

#if (CONFIG_ALARM_TIMER == TIMER_TCA) || (CONFIG_ALARM_TIMER == TIMER_TCA8)
    friend void AlarmClass_timeup(TcaBase::CMP);
#else
    friend void AlarmClass_timeup(void);
#endif

    Alarm *_alarm_list;
    bool _poll_mode;
};

extern AlarmClass AlarmTimer;

#endif
