/*
  avr8_config.h - Driver Configuration for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#pragma once

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/eeprom.h>
#include "avr8_main.h"

/* VDD/VREFA/EXTCLK */
#define CONFIG_VDD    3300 /* mV */
#define CONFIG_VREFA  0    /* mV */
#define CONFIG_EXTCLK 0    /* Hz */

/* CLOCK */
#define CONFIG_CLOCK_FRQSEL Clock::FRQSEL_16M

/* TASK */
#define CONFIG_TASK_USE 0
#define CONFIG_TASK_STACK_SIZE 256

/* ALARM */
#define CONFIG_ALARM_USE 0
/* Sets which of the RTC/TCA/TCA8/TCB to use as the timer */
#define CONFIG_ALARM_TIMER TIMER_RTC
// #define CONFIG_ALARM_TIMER TIMER_TCA
// #define CONFIG_ALARM_TIMER TIMER_TCA8
// #define CONFIG_ALARM_TIMER TIMER_TCB
/* Detailed settings for TCA used as a timer */
#define CONFIG_ALARM_TIMER_TCA TCA0
#define CONFIG_ALARM_TIMER_TCA_CMP TcaBase::CMP2
/* Detailed settings for TCB used as a timer */
#define CONFIG_ALARM_TIMER_TCB TCB0

/* PORT */
#define CONFIG_PORT_ISR 0
#define CONFIG_PORT_POLL 0

/* RTC */
#define CONFIG_RTC_USE  0

/* TCA */
#define CONFIG_TCA_ISR 0
#define CONFIG_TCA_POLL 0

/* TCB */
#define CONFIG_TCB_ISR 0
#define CONFIG_TCB_POLL 0

/* ADC */
#define CONFIG_ADC_CLOCK 1000000UL

/* AC */
#define CONFIG_AC_ISR 0
#define CONFIG_AC_POLL 0

/* USART */
#define CONFIG_USART_ISR 0
#define CONFIG_USART_POLL 0
#define CONFIG_USART_RXBUF_SIZE 8   /* Set a power of 2 value (0,1,2,4,8,...,128) */
#define CONFIG_USART_TXBUF_SIZE 0   /* Set a power of 2 value (0,1,2,4,8,...,128) */

/* ZCD */
#define CONFIG_ZCD_ISR 0
#define CONFIG_ZCD_POLL 0

/* TWI */
#define CONFIG_TWI_IOBUF_SIZE  16        /* class TwoWire Buffer Size */
#define CONFIG_TWI_BUS_TIMEOUT 200000UL  /* BUS Timeout (us) */

/* Device Family Type */
#if  defined(__AVR_ATtiny202__) || defined(__AVR_ATtiny204__) \
  || defined(__AVR_ATtiny402__) || defined(__AVR_ATtiny404__) || defined(__AVR_ATtiny406__) \
  || defined(__AVR_ATtiny804__) || defined(__AVR_ATtiny806__) || defined(__AVR_ATtiny807__) \
  || defined(__AVR_ATtiny1604__) || defined(__AVR_ATtiny1606__) || defined(__AVR_ATtiny1607__)
  #define __AVR_0__
#elif defined(__AVR_ATtiny212__) || defined(__AVR_ATtiny214__) \
  || defined(__AVR_ATtiny412__) || defined(__AVR_ATtiny414__) || defined(__AVR_ATtiny416__) || defined(__AVR_ATtiny417__) \
  || defined(__AVR_ATtiny814__) || defined(__AVR_ATtiny816__) || defined(__AVR_ATtiny817__) \
  || defined(__AVR_ATtiny1614__) || defined(__AVR_ATtiny1616__) || defined(__AVR_ATtiny1617__) \
  || defined(__AVR_ATtiny3216__) || defined(__AVR_ATtiny3217__)
  #define __AVR_1__
#elif defined(__AVR_ATtiny424__) || defined(__AVR_ATtiny426__) || defined(__AVR_ATtiny427__) \
  || defined(__AVR_ATtiny824__) || defined(__AVR_ATtiny826__) || defined(__AVR_ATtiny827__) \
  || defined(__AVR_ATtiny1624__) || defined(__AVR_ATtiny1626__) || defined(__AVR_ATtiny1627__) \
  || defined(__AVR_ATtiny3224__) || defined(__AVR_ATtiny3226__) || defined(__AVR_ATtiny3227__)
  #define __AVR_2__
#elif defined(__AVR_AVR32DA28__) || defined(__AVR_AVR32DA32__) || defined(__AVR_AVR32DA48__) \
  || defined(__AVR_AVR32DA28S__) || defined(__AVR_AVR32DA32S__) || defined(__AVR_AVR32DA48S__) \
  || defined(__AVR_AVR64DA28__) || defined(__AVR_AVR64DA32__) || defined(__AVR_AVR64DA48__) || defined(__AVR_AVR64DA64__) \
  || defined(__AVR_AVR64DA28S__) || defined(__AVR_AVR64DA32S__) || defined(__AVR_AVR64DA48S__) || defined(__AVR_AVR64DA64S__) \
  || defined(__AVR_AVR128DA28__) || defined(__AVR_AVR128DA32__) || defined(__AVR_AVR128DA48__) || defined(__AVR_AVR128DA64__) \
  || defined(__AVR_AVR128DA28S__) || defined(__AVR_AVR128DA32S__) || defined(__AVR_AVR128DA48S__) || defined(__AVR_AVR128DA64S__)
  #define __AVR_DA__
#elif defined(__AVR_AVR32DB28__) || defined(__AVR_AVR32DB32__) || defined(__AVR_AVR32DB48__) \
  || defined(__AVR_AVR64DB28__) || defined(__AVR_AVR64DB32__) || defined(__AVR_AVR64DB48__) || defined(__AVR_AVR64DB64__) \
  || defined(__AVR_AVR128DB28__) || defined(__AVR_AVR128DB32__) || defined(__AVR_AVR128DB48__) || defined(__AVR_AVR128DB64__)
  #define __AVR_DB__
#elif defined(__AVR_AVR16DD14__) || defined(__AVR_AVR16DD20__) || defined(__AVR_AVR16DD28__) || defined(__AVR_AVR16DD32__) \
  || defined(__AVR_AVR32DD14__) || defined(__AVR_AVR32DD20__) || defined(__AVR_AVR32DD28__) || defined(__AVR_AVR32DD32__)   \
  || defined(__AVR_AVR64DD14__) || defined(__AVR_AVR64DD20__) || defined(__AVR_AVR64DD28__) || defined(__AVR_AVR64DD32__)
  #define __AVR_DD__
#elif defined(__AVR_AVR16DU14__) || defined(__AVR_AVR16DU20__) || defined(__AVR_AVR16DU28__) || defined(__AVR_AVR16DU32__) \
  || defined(__AVR_AVR32DU14__) || defined(__AVR_AVR32DU20__) || defined(__AVR_AVR32DU28__) || defined(__AVR_AVR32DU32__) \
  || defined(__AVR_AVR64DU28__) || defined(__AVR_AVR64DU32__)
  #define __AVR_DU__
#elif defined(__AVR_AVR16EA28__) || defined(__AVR_AVR16EA32__) || defined(__AVR_AVR16EA48__) \
  || defined(__AVR_AVR32EA28__) || defined(__AVR_AVR32EA32__) || defined(__AVR_AVR32EA48__) \
  || defined(__AVR_AVR64EA28__) || defined(__AVR_AVR64EA32__) || defined(__AVR_AVR64EA48__)
  #define __AVR_EA__
#elif defined(__AVR_AVR16EB14__) || defined(__AVR_AVR16EB20__) || defined(__AVR_AVR16EB28__) || defined(__AVR_AVR16EB32__) \
  || defined(__AVR_AVR32EB14__) || defined(__AVR_AVR32EB20__) || defined(__AVR_AVR32EB28__) || defined(__AVR_AVR32EB32__)
  #define __AVR_EB__
// #elif defined(__AVR_AVR32SD20__) || defined(__AVR_AVR32SD28__) || defined(__AVR_AVR32SD32__)
//   #define __AVR_SD__
#else
  #error "unsupported device type."
#endif
