/*
  avr8_main.cpp - main routine
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#include "avr8_main.h"
#include "avr8_task.h"
#include "avr8_clock.h"
#include "avr8_rtc.h"
#include "avr8_port.h"
#include "avr8_tca.h"
#include "avr8_tcb.h"
#include "avr8_ac.h"
#include "avr8_usart.h"
#include "avr8_zcd.h"

void sysinit(void)
{
#if defined(CONFIG_CLOCK_FRQSEL) && defined(CLKCTRL_FRQSEL_gm)
  Clock::setup(CONFIG_CLOCK_FRQSEL);
#else
  Clock::setup();
#endif
#if CONFIG_RTC_USE && !((CONFIG_TASK_USE || CONFIG_ALARM_USE) && (CONFIG_ALARM_TIMER == TIMER_RTC))
  Rtc::begin();
  Rtc::run();
#endif
#if CONFIG_TASK_USE
  Task::begin();
#elif CONFIG_ALARM_USE
  AlarmTimer.begin();
#endif
  sei();
}

void avr8_yield(void) __attribute__((weak));
void avr8_yield(void)
{
}

static void yield0(void)
{
  avr8_yield();
#if CONFIG_PORT_POLL && !CONFIG_PORT_ISR
  Port::poll();
#endif
#if CONFIG_TCA_POLL && !CONFIG_TCA_ISR
  TcaBase::poll();
#endif
#if CONFIG_TCB_POLL && !CONFIG_TCB_ISR
  Tcb::poll();
#endif
#if CONFIG_AC_POLL && !CONFIG_AC_ISR
  Ac::poll();
#endif
#if CONFIG_USART_POLL && !CONFIG_USART_ISR
  Usart::poll();
#endif
#if CONFIG_ZCD_POLL && !CONFIG_ZCD_ISR
  Zcd::poll();
#endif
#if CONFIG_TASK_USE
  Task::yield();
#elif CONFIG_ALARM_USE
  AlarmTimer.handle();
#endif
}

void yield(void)
{
  yield0();
}

void setup(void) __attribute__((weak));
void setup(void)
{
}

void loop(void) __attribute__((weak));
void loop(void)
{
}

int main(void) __attribute__((weak));
int main(void)
{
  sysinit();
  setup();
  while (1)
  {
    loop();
    yield0();
  }
  return 0;
}