/*
  avr8_port.cpp - PORT Driver for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#include "avr8_port.h"

Port::callback_t Port::_callback[];

#if CONFIG_PORT_ISR

inline void port_isr_port(uint8_t ch, VPORT_t &port)
{
  Port::isr_port(ch, port);
}

#if defined(PORTA_PORT_vect)
ISR(PORTA_PORT_vect)
{
  port_isr_port(0, VPORTA);
}
#endif

#if defined(PORTB_PORT_vect)
ISR(PORTB_PORT_vect)
{
  port_isr_port(1, VPORTB);
}
#endif

#if defined(PORTC_PORT_vect)
ISR(PORTC_PORT_vect)
{
  port_isr_port(2, VPORTC);
}
#endif

#if defined(PORTD_PORT_vect)
ISR(PORTD_PORT_vect)
{
  port_isr_port(3, VPORTD);
}
#endif

#if defined(PORTE_PORT_vect)
ISR(PORTE_PORT_vect)
{
  port_isr_port(4, VPORTE);
}
#endif

#if defined(PORTF_PORT_vect)
ISR(PORTF_PORT_vect)
{
  port_isr_port(5, VPORTF);
}
#endif

#if defined(PORTG_PORT_vect)
ISR(PORTG_PORT_vect)
{
  port_isr_port(6, VPORTG);
}
#endif

#endif
