/*
  avr8_reset.h - Reset Control Driver for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#pragma once

#include "avr8_config.h"

#if defined(RSTCTRL_SWRE_bm)
  #define RSTCTRL_SWRST_bm RSTCTRL_SWRE_bm
#endif

class Reset
{
  public:

    /* RSTCTRL.RSTFR  bit masks and bit positions */
    typedef enum
    {
      STATUS_PORF   = RSTCTRL_PORF_bm,   /* Power on Reset flag bit mask. */
      STATUS_BORF   = RSTCTRL_BORF_bm,   /* Brown out detector Reset flag bit mask. */
      STATUS_EXTRF  = RSTCTRL_EXTRF_bm,  /* External Reset flag bit mask. */
      STATUS_WDRF   = RSTCTRL_WDRF_bm,   /* Watch dog Reset flag bit mask. */
      STATUS_SWRF   = RSTCTRL_SWRF_bm,   /* Software Reset flag bit mask. */
      STATUS_UPDIRF = RSTCTRL_UPDIRF_bm, /* UPDI Reset flag bit mask. */
    } STATUS;

    static STATUS status(void)
    {
      return (STATUS)RSTCTRL.RSTFR;
    }

    static void swreset(void)
    {
      RSTCTRL.SWRR = RSTCTRL_SWRST_bm;
    }
};