/*
  avr8_rtc.cpp - RTC Driver for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#include "avr8_rtc.h"

#if CONFIG_RTC_USE || ((CONFIG_TASK_USE || CONFIG_ALARM_USE) && (CONFIG_ALARM_TIMER == TIMER_RTC))

uint16_t          Rtc::_khz;
volatile uint16_t Rtc::_overflow;
volatile uint16_t Rtc::_counter;
uint32_t          Rtc::_interval;
Rtc::callback_t   Rtc::_callback[];

__attribute__((weak)) void yield1(void)
{
}

inline void rtc_isr_cnt(void)
{
  Rtc::isr_cnt();  
}

inline void rtc_isr_pit(void)
{
  Rtc::isr_pit();
}

ISR(RTC_CNT_vect)
{
  rtc_isr_cnt();
}

ISR(RTC_PIT_vect)
{
  rtc_isr_pit();
}

#endif
