/*
  avr8_tca.cpp - TCA Driver for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#include "avr8_tca.h"

#if TCA_MAX_CH

const uint16_t TcaBase::CLKDIV[] = { 1, 2, 4, 8, 16, 64, 256, 1024 };

TcaBase* TcaBase::_instances[];

void TcaBase::end(void)
{
  switch (_dct)
  {
    case DCT_TCA : ((Tca* )this)->end(); break;
    case DCT_TCA8: ((Tca8*)this)->end(); break;
  }
}

void TcaBase::isr_ovf(void)
{
  switch (_dct)
  {
    case DCT_TCA : ((Tca* )this)->isr_ovf(); break;
    case DCT_TCA8: ((Tca8*)this)->isr_ovf(); break;
  }
}

void TcaBase::isr_cmp(CMP cmp)
{
  switch (_dct)
  {
    case DCT_TCA : ((Tca* )this)->isr_cmp(cmp); break;
    case DCT_TCA8: ((Tca8*)this)->isr_cmp(cmp); break;
  }
}

#if CONFIG_TCA_ISR

inline void tca_isr_ovf(uint8_t ch)
{
  TcaBase::_instances[ch]->isr_ovf();
}

inline void tca_isr_cmp(uint8_t ch, TcaBase::CMP cmp)
{
  TcaBase::_instances[ch]->isr_cmp(cmp);
}

#if defined(TCA0_OVF_vect)
ISR(TCA0_OVF_vect)
{
  tca_isr_ovf(0);
}
#endif

#if defined(TCA0_CMP0_vect)
ISR(TCA0_CMP0_vect)
{
  tca_isr_cmp(0, TcaBase::CMP0);
}
#endif

#if defined(TCA0_CMP1_vect)
ISR(TCA0_CMP1_vect)
{
  tca_isr_cmp(0, TcaBase::CMP1);
}
#endif

#if defined(TCA0_CMP2_vect)
ISR(TCA0_CMP2_vect)
{
  tca_isr_cmp(0, TcaBase::CMP2);
}
#endif

#if defined(TCA1_OVF_vect)
ISR(TCA1_OVF_vect)
{
  tca_isr_ovf(1);
}
#endif

#if defined(TCA1_CMP0_vect)
ISR(TCA1_CMP0_vect)
{
  tca_isr_cmp(1, TcaBase::CMP0);
}
#endif

#if defined(TCA1_CMP1_vect)
ISR(TCA1_CMP1_vect)
{
  tca_isr_cmp(1, TcaBase::CMP1);
}
#endif

#if defined(TCA1_CMP2_vect)
ISR(TCA1_CMP2_vect)
{
  tca_isr_cmp(1, TcaBase::CMP2);
}
#endif

#endif

#endif
