/*
  avr8_tcb.cpp - TCB Driver for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#include "avr8_tcb.h"

const uint16_t Tcb::CLKDIV[] = { 1, 2, 4, 8, 16, 64, 256, 1024 };
Tcb* Tcb::_instances[];

#if CONFIG_TCB_ISR

inline void tcb_isr_capt(uint8_t ch)
{
  Tcb::_instances[ch]->isr_capt();
}

#if defined(TCB0_INT_vect)
ISR(TCB0_INT_vect)
{
  tcb_isr_capt(0);
}
#endif

#if defined(TCB1_INT_vect)
ISR(TCB1_INT_vect)
{
  tcb_isr_capt(1);
}
#endif

#if defined(TCB2_INT_vect)
ISR(TCB2_INT_vect)
{
  tcb_isr_capt(2);
}
#endif

#if defined(TCB3_INT_vect)
ISR(TCB3_INT_vect)
{
  tcb_isr_capt(3);
}
#endif

#if defined(TCB4_INT_vect)
ISR(TCB4_INT_vect)
{
  tcb_isr_capt(4);
}
#endif

#endif

