/*
  avr8_timer.h - Timer Library for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#pragma once

#include <stddef.h>
#include <stdint.h>
#include <stdbool.h>
#include "avr8_config.h"

#if CONFIG_TASK_USE || CONFIG_ALARM_USE

typedef uint8_t sreg_t;

class TimerClass
{
  public:

    /* Interrupt Control */
    static sreg_t disableAndSaveInterrupts(void);
    static void restoreInterrupts(sreg_t save);
    static void idle(void);

  protected:

    /* For Alarm Class */
    static bool setupAlarmTimer(void);
    static void startAlarmTimer(int32_t interval);
};

#define TIMER_RTC  1
#define TIMER_TCA  2
#define TIMER_TCA8 3
#define TIMER_TCB  4

#if CONFIG_ALARM_TIMER == TIMER_RTC
  #include "avr8_rtc.h"
  extern Rtc Timer;
#elif CONFIG_ALARM_TIMER == TIMER_TCA
  #include "avr8_tca.h"
  extern Tca Timer;
#elif CONFIG_ALARM_TIMER == TIMER_TCA8
  #include "avr8_tca.h"
  extern Tca8 Timer;
#elif CONFIG_ALARM_TIMER == TIMER_TCB
  #include "avr8_tcb.h"
  extern Tcb Timer;
#else
  #error "CONFIG_ALARM_TIMER mistake"
#endif

#endif
