/*
  avr8_usart.cpp - USART Driver for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#include "avr8_usart.h"

Usart *Usart::_instances[];

#if CONFIG_USART_ISR

#if CONFIG_USART_RXBUF_SIZE

inline void usart_isr_rxc(uint8_t ch)
{
  Usart::_instances[ch]->isr_rxc();
}

#if defined(USART0_RXC_vect)
ISR(USART0_RXC_vect)
{
  usart_isr_rxc(0);
}
#endif

#if defined(USART1_RXC_vect)
ISR(USART1_RXC_vect)
{
  usart_isr_rxc(1);
}
#endif

#if defined(USART2_RXC_vect)
ISR(USART2_RXC_vect)
{
  usart_isr_rxc(2);
}
#endif

#if defined(USART3_RXC_vect)
ISR(USART3_RXC_vect)
{
  usart_isr_rxc(3);
}
#endif

#if defined(USART4_RXC_vect)
ISR(USART4_RXC_vect)
{
  usart_isr_rxc(4);
}
#endif

#if defined(USART5_RXC_vect)
ISR(USART5_RXC_vect)
{
  usart_isr_rxc(5);
}
#endif

#endif // CONFIG_USART_RXBUF_SIZE

#if CONFIG_USART_TXBUF_SIZE

inline void usart_isr_dre(uint8_t ch)
{
  Usart::_instances[ch]->isr_dre();
}

#if defined(USART0_DRE_vect)
ISR(USART0_DRE_vect)
{
  usart_isr_dre(0);
}
#endif

#if defined(USART1_DRE_vect)
ISR(USART1_DRE_vect)
{
  usart_isr_dre(1);
}
#endif

#if defined(USART2_DRE_vect)
ISR(USART2_DRE_vect)
{
  usart_isr_dre(2);
}
#endif

#if defined(USART3_DRE_vect)
ISR(USART3_DRE_vect)
{
  usart_isr_dre(3);
}
#endif

#if defined(USART4_DRE_vect)
ISR(USART4_DRE_vect)
{
  usart_isr_dre(4);
}
#endif

#if defined(USART5_DRE_vect)
ISR(USART5_DRE_vect)
{
  usart_isr_dre(5);
}
#endif

#endif // CONFIG_USART_TXBUF_SIZE

#endif // CONFIG_USART_ISR

