/*
  avr8_zcd.cpp - ZCD Driver for Microchip AVR8 Series
 
  Copyright (c) 2025 Sasapea's Lab. All right reserved.
 
  This program is free software: you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of
  the License, or at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#include "avr8_zcd.h"

#if ZCD_MAX_CH

Zcd* Zcd::_instances[];

#if CONFIG_ZCD_ISR

inline void zcd_isr(uint8_t ch)
{
  Zcd::_instances[ch]->isr();
}

#if defined(ZCD0_ZCD_vect)
ISR(ZCD0_ZCD_vect)
{
  zcd_isr(0);
}
#endif

#if defined(ZCD1_ZCD_vect)
ISR(ZCD1_ZCD_vect)
{
  zcd_isr(1);
}
#endif

#if defined(ZCD2_ZCD_vect)
ISR(ZCD2_ZCD_vect)
{
  zcd_isr(2);
}
#endif

#if defined(ZCD3_ZCD_vect)
ISR(ZCD3_ZCD_vect)
{
  zcd_isr(3);
}
#endif

#endif

#endif